<?php
/*-----------------------------------------------------------------
* 	ID:						css_styler.php
* 	Letzter Stand:			v2.2 R365
* 	zuletzt geaendert von:	akausch
* 	Datum:					2012/07/03
*
* 	Copyright (c) since 2010 commerce:SEO by Webdesign Erfurt
* 	http://www.commerce-seo.de
* ------------------------------------------------------------------
* 	based on:
* 	(c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
* 	(c) 2002-2003 osCommerce - www.oscommerce.com
* 	(c) 2003     nextcommerce - www.nextcommerce.org
* 	(c) 2005     xt:Commerce - www.xt-commerce.com
* 	Released under the GNU General Public License
* ---------------------------------------------------------------*/


require('includes/application_top.php');

$max_age = 60 * 60 * 24 * 7;
header('Content-Type: text/css');
header('Cache-Control: public, max-age=' . $max_age);
header('Expires: ' . gmdate('D, d M Y H:i:s', time() + $max_age) . ' GMT');
header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");
// ob_start("ob_gzhandler");

$css_cache_datei = DIR_FS_CATALOG.'cache/cseo-css-v2-cache-file.css';
$erzeuge_cache = false;

if(file_exists($css_cache_datei) == false) {
	$erzeuge_cache = true;
} elseif(filesize($css_cache_datei) < 10) {
	$erzeuge_cache = true;
} elseif(filemtime($css_cache_datei) < time() - 86400) {
	$erzeuge_cache = true;
}

if($erzeuge_cache === false) {
	include($css_cache_datei);
} else {

	function getHex($value) {
		$v = substr($value,0,6);
		return '#'.$v;
	}
	if(CSS_BUTTON_ACTIVE == 'true' && CSS_BUTTON_ACTIVE != 'css') {
		if(CSS_BUTTON_BACKGROUND_1 !='' || CSS_BUTTON_BACKGROUND_2 !=''){
			$background = ' url(cseo_css_img.php?w=1&h=40&c1='.CSS_BUTTON_BACKGROUND_1.'&c2='.CSS_BUTTON_BACKGROUND_2.') repeat-x 0 100%';
		} elseif(CSS_BUTTON_BACKGROUND_PIC !='')
			$background = ' url(images/css_button_bg/'.CSS_BUTTON_BACKGROUND_PIC.') repeat-x 0 100%';
		

		$css = 'input.css_img_button, a span.css_img_button { background:'.getHex(CSS_BUTTON_BACKGROUND).$background.';';

		if(CSS_BUTTON_BORDER_WIDTH > 0 && CSS_BUTTON_BORDER_STYLE !='none') {
			$css .= 'border:'.CSS_BUTTON_BORDER_WIDTH.' '.CSS_BUTTON_BORDER_STYLE.' '.getHex(CSS_BUTTON_BORDER_COLOR).';';
		} else {
			$css .= 'border: 0;';
		}

		$css .= 'color:'.getHex(CSS_BUTTON_FONT_COLOR).';
			cursor:pointer;
			margin-bottom: 2px; 
			font-family: '.CSS_BUTTON_FONT_FAMILY.';'
			.(CSS_BUTTON_FONT_SIZE!=''? 'font-size:'.CSS_BUTTON_FONT_SIZE.';' : '').'
			font-style:normal;
			font-variant:normal;
			font-weight:normal;
			display:inline-block;
			line-height:2.0em;'
			.((CSS_BUTTON_FONT_ITALIC == 'true') ? 'font-style: italic;' : '').
			'padding:0 4px;
			text-align:center !important;
			white-space:nowrap;';
		if(CSS_BUTTON_BORDER_RADIUS !='')
			$css .= 'border-radius:'.CSS_BUTTON_BORDER_RADIUS.';';
		if(CSS_BUTTON_FONT_SHADOW !='')
			$css .= 'text-shadow:'.CSS_BUTTON_FONT_SHADOW.';';
		if(CSS_BUTTON_MISC !='')
			$css .= CSS_BUTTON_MISC;
		$css .= '}';
	
		$css .= 'a span.css_img_button {
					line-height:2.0em; padding: 1px 4px;
				}';
		$css .= 'input.css_img_button{height:2.3em;padding: 2px 4px 4px 4px;}';
		$css .= 'a:hover .css_img_button, input.css_img_button:hover {';

		if(CSS_BUTTON_HOVER_BACKGROUND_1 !='' || CSS_BUTTON_HOVER_BACKGROUND_2 !='')
			$background_hover = ' url(cseo_css_img.php?w=1&h=40&c1='.CSS_BUTTON_HOVER_BACKGROUND_1.'&c2='.CSS_BUTTON_HOVER_BACKGROUND_2.') repeat-x 0 100%';
		elseif(CSS_BUTTON_BACKGROUND_HOVER !='' || CSS_BUTTON_BACKGROUND_PIC_HOVER !='') {
			if(CSS_BUTTON_BACKGROUND_PIC_HOVER !='')
				$background_hover = ' url(images/css_button_bg/'.CSS_BUTTON_BACKGROUND_PIC_HOVER.') repeat-x scroll 0 100%';
		}
		$css .= 'background:' . getHex(CSS_BUTTON_BACKGROUND_HOVER).$background_hover . ';';
		if(CSS_BUTTON_BORDER_COLOR_HOVER !='')
			$css .= 'border-color:'.getHex(CSS_BUTTON_BORDER_COLOR_HOVER).';';
		if(CSS_BUTTON_FONT_COLOR_HOVER!='')
			$css .= 'color:'.getHex(CSS_BUTTON_FONT_COLOR_HOVER).';';
		$css .= '}';

		$css .= 'a.css_img_button:link,a.css_img_button:visited,a.css_img_button:active,a:hover .css_img_button { text-decoration: none; }';
		
		
		//Warenkorb button
	
		if(WK_CSS_BUTTON_BACKGROUND_1 !='' || WK_CSS_BUTTON_BACKGROUND_2 !=''){
			$wk_background = ' url(cseo_css_img.php?w=1&h=40&c1='.WK_CSS_BUTTON_BACKGROUND_1.'&c2='.WK_CSS_BUTTON_BACKGROUND_2.') repeat-x 0 100%';
		}
		$css .= 'input.css_wk_img_button, a span.css_wk_img_button { background:'.getHex(WK_CSS_BUTTON_BACKGROUND).$wk_background.';';
		
		if(CSS_BUTTON_BORDER_WIDTH > 0 && CSS_BUTTON_BORDER_STYLE !='none') {
			$css .= 'border:'.CSS_BUTTON_BORDER_WIDTH.' '.CSS_BUTTON_BORDER_STYLE.' '.getHex(WK_CSS_BUTTON_BORDER_COLOR).';';
		} else {
			$css .= 'border: 0;';
		}

		$css .= 'color:'.getHex(WK_CSS_BUTTON_FONT_COLOR).';
			cursor:pointer;
			margin-bottom: 2px; 
			font-family: '.CSS_BUTTON_FONT_FAMILY.';'
			.(CSS_BUTTON_FONT_SIZE!=''? 'font-size:'.CSS_BUTTON_FONT_SIZE.';' : '').'
			font-style:normal;
			font-variant:normal;
			font-weight:normal;
			display:inline-block;
			line-height:2.0em;'
			.((CSS_BUTTON_FONT_ITALIC == 'true') ? 'font-style: italic;' : '').
			'padding:0 4px;
			text-align:center !important;
			white-space:nowrap;';
		if(CSS_BUTTON_BORDER_RADIUS !='')
			$css .= 'border-radius:'.CSS_BUTTON_BORDER_RADIUS.';';
		if(WK_CSS_BUTTON_FONT_SHADOW !='')
			$css .= 'text-shadow:'.WK_CSS_BUTTON_FONT_SHADOW.';';
		if(CSS_BUTTON_MISC !='')
			$css .= CSS_BUTTON_MISC;
		$css .= '}';
	
		$css .= 'a span.css_wk_img_button {
					line-height:2.0em; padding: 1px 4px;
				}';
		$css .= 'input.css_wk_img_button{height:2.3em;padding: 2px 4px 4px 4px;}';
		$css .= 'a:hover .css_wk_img_button, input.css_wk_img_button:hover {';

		if(WK_CSS_BUTTON_HOVER_BACKGROUND_1 !='' || WK_CSS_BUTTON_HOVER_BACKGROUND_2 !='')
			$background_hover = ' url(cseo_css_img.php?w=1&h=40&c1='.WK_CSS_BUTTON_HOVER_BACKGROUND_1.'&c2='.WK_CSS_BUTTON_HOVER_BACKGROUND_2.') repeat-x 0 100%';
		elseif(CSS_BUTTON_BACKGROUND_HOVER !='' || CSS_BUTTON_BACKGROUND_PIC_HOVER !='') {
			if(CSS_BUTTON_BACKGROUND_PIC_HOVER !='')
				$background_hover = ' url(images/css_button_bg/'.CSS_BUTTON_BACKGROUND_PIC_HOVER.') repeat-x scroll 0 100%';
		}
		$css .= 'background:' . getHex(CSS_BUTTON_BACKGROUND_HOVER).$background_hover . ';';
		if(CSS_BUTTON_BORDER_COLOR_HOVER !='')
			$css .= 'border-color:'.getHex(CSS_BUTTON_BORDER_COLOR_HOVER).';';
		if(WK_CSS_BUTTON_FONT_COLOR_HOVER!='')
			$css .= 'color:'.getHex(WK_CSS_BUTTON_FONT_COLOR_HOVER).';';
		$css .= '}';

		$css .= 'a.css_wk_img_button:link,a.css_wk_img_button:visited,a.css_wk_img_button:active,a:hover .css_wk_img_button { text-decoration: none; }';
			
		
	}
	$output = str_replace("\n",'',$css);
	$output = str_replace("\t",'',$output);

	$fp = fopen($css_cache_datei, 'w+');
	fwrite($fp, $output);
	fclose($fp);
	
	echo trim($output);
}
